<?php

class Geolookup {

	/**
	 * GetCountyRegionCity - Lookup country, region, city codes
	 * @param $ip int
	 */
	public static function GetCountyRegionCity($ip){
		/** @var $f3 \Base */
		$f3=Base::instance();
		$cache = \Cache::instance();
		$codes = array();
		if ($cache->exists($ip.'geocity',$codes)) return ($codes);

		if (!file_exists($f3->get('TEMP').'GeoLiteCity.dat')) return ($codes);
		include_once(dirname(__FILE__) . '/../geoip/geoipcity.inc');
		$gi = geoip_open($f3->get('TEMP').'GeoLiteCity.dat', GEOIP_STANDARD);
		$record = geoip_record_by_addr($gi, $ip);
		if (empty($record)) return ($codes);
		$region = ltrim($record->region, '0');
		$codes['country'] = strtoupper($record->country_code);
		$codes['region'] = strtoupper($record->country_code.'|'.$region);
		$codes['city'] = strtoupper($record->country_code.'|'.$region.'|'.urlencode($record->city));
		geoip_close($gi);

		$cache->set($ip.'geocity', $codes, 86400);
		return ($codes);
	}

	public static function ClearGeoCache(){
		$cache = \Cache::instance();
		$cache->reset('geocity', 86400); // reset day old cache
	}

	/**
	 * GetCounty - Lookup country code
	 * @param $ip int
	 */
	public static function GetCounty($ip){
	}

}