function drawChart() {

	var data = new google.visualization.DataTable(chartData);

	var options = {
		legend: { position: 'bottom',textStyle: {fontSize: '10'} },
		backgroundColor: '#E5E5E5',
		pointSize: 4,
		fontName: 'Open Sans',
		chartArea: {width: '85%', height: '70%'},
		vAxis: {minValue: 0, format: '0', viewWindow: {min: 0}, gridlines: {count: -1}},
		colors: ['#2574A9','#70757B','#B9493E']
	};

	var chart = new google.visualization.AreaChart(document.getElementById('stats_chart'));
	chart.draw(data, options);

}

function drawPieChart() {

	var data = new google.visualization.DataTable(geoChartData);
	data.sort({column: 1, desc: true});
	
  var options = {
		legend: { position: 'right',textStyle: {fontSize: '12'} },
		backgroundColor: '#E5E5E5',
		fontName: 'Open Sans',
    pieHole: 0.2
  };

	var chart = new google.visualization.PieChart(document.getElementById('stats_geo_graph'));
        chart.draw(data, options);

}

function drawGeoChart() {

	var data = new google.visualization.DataTable(geoChartData);

	var goptions = {
		backgroundColor: '#E5E5E5',
		displayMode: 'markers',
		legend: 'none'
	};

	var geochart = new google.visualization.GeoChart(document.getElementById('stats_geo_chart'));
	geochart.draw(data, goptions);

}

$(document).ready(function () {

	$("#referer_table").tablesorter({sortList: [[2,1]]}).tablesorterPager({container: $("#referer_pager")});
	$("#hostname_table").tablesorter({sortList: [[2,1]]}).tablesorterPager({container: $("#hostname_pager")});
	$("#browser_table").tablesorter({sortList: [[2,1]]}).tablesorterPager({container: $("#browser_pager")});
	$("#os_table").tablesorter({sortList: [[2,1]]}).tablesorterPager({container: $("#os_pager")});
	$("#device_table").tablesorter({sortList: [[2,1]]}).tablesorterPager({container: $("#device_pager")});

	$(window).resize(function(){
		drawChart();
		//drawGeoChart();
		drawPieChart();
	});
});


function createDataTable() {
	var responsiveHelper;
	var breakpointDefinition = {
		tablet: 1024,
		phone : 480
	};
	var tableElement = $('#dataTable');
	/*----------- BEGIN datatable CODE -------------------------*/
	tableElement.dataTable({
		tableTools: {
			"sSwfPath": "ui/default/assets/lib/datatables/extensions/swf/copy_csv_xls_pdf.swf"
		},
		sDom: "<'pull-right'lT>t<'row'<'col-lg-6'f><'col-lg-6'p>>",
		pagingType: 'full_numbers',
		stateSave: true,
		stateDuration: 60 * 60 * 24 * 365,
		stateSaveCallback: function (settings, data) {
			localStorage.setItem('mysa_dt_stats', JSON.stringify(data));
		},
		stateLoadCallback: function (settings) {
			return (JSON.parse(localStorage.getItem('mysa_dt_stats')));
		},
		oLanguage: {
			sLengthMenu: lang_show + " _MENU_ " + lang_entries,
			sSearch: lang_search + ":",
			sZeroRecords: lang_no_listings,
			oPaginate: {
				sNext: lang_next,
				sPrevious: lang_previous
			}
		},
		// Setup for responsive datatables helper.
		bAutoWidth     : false,
		fnPreDrawCallback: function () {
			// Initialize the responsive datatables helper once.
			if (!responsiveHelper) {
				responsiveHelper = new ResponsiveDatatablesHelper(tableElement, breakpointDefinition);
			}
		},
		fnRowCallback  : function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
			responsiveHelper.createExpandIcon(nRow);
		},
		fnDrawCallback : function (oSettings) {
			responsiveHelper.respond();
		}
	});
	tableElement.fnSort( [ [0,'desc'] ] );
	/*----------- END datatable CODE -------------------------*/
}