$(function() {

	$('#reportrange').daterangepicker(
			{
				format: 'YYYY/MM/DD',
				ranges: {
					'Today': [moment(), moment()],
					'Yesterday': [moment().subtract('days', 1), moment().subtract('days', 1)],
					'Last 7 Days': [moment().subtract('days', 6), moment()],
					'Last 30 Days': [moment().subtract('days', 29), moment()],
					'This Month': [moment().startOf('month'), moment().endOf('month')],
					'Last Month': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')]
				},
				startDate: moment().subtract('days', 6),
				endDate: moment()
			}
	);


	$('#stats_form').submit(function( event ) {

		$('#stats_section').html('').load( "index.php?stats", $('#stats_form').serializeArray()  ,function( response, status, xhr ) {
			if ( status == "error" ) {
				var msg = "Sorry but there was an error: ";
				$( "#stats_loaded" ).html( msg + xhr.status + " " + xhr.statusText );
			}
			$.getScript(ui + 'assets/js/stats-graphs.js');

			setTimeout(function(){google.load('visualization', '1', {'callback':'drawChart', 'packages':['corechart']})}, 2000);
			setTimeout(function(){createDataTable()}, 2000);
			if (geoChartData != ""){
				setTimeout(function(){google.load('visualization', '1', {'callback':'drawPieChart', 'packages':['geochart']})}, 2000);
			}

			$('#stats_section').css({
				height:$("#stats_loaded").height()
			});
		});

		event.preventDefault();
	});




});