var finished = false;
$(function() {

	$("#wizardForm").formwizard({
				textSubmit: lang_setup,
				formPluginEnabled: true,
				validationEnabled: true,
				focusFirstInput: true,
				remoteAjax : {"first" : { // add a remote ajax call when moving next from the second step
					url : "index.php?spots&buy&account&email&check",
					dataType : 'json',
					success : function(data){
						if(data.exists == 'true'){ // change this value to false in validate.html to simulate successful validation
							$('#div_new').hide();
						} else {
							$('#div_exists').hide();
						}

						return true; //return true to make the wizard move to the next step
					}
				}},
				formOptions: {
					beforeSubmit: function(data) {
						if (finished) return false;

						$("#next").attr("disabled", "disabled");
						$("#data").html('<div class="alert alert-warning"><img src="' + ui + 'assets/img/wait.gif" alt="wait"/> ' + lang_setting_things_up + '...</div>');
						return true;
					},
					error: function(data){
						$("#next").attr("disabled", "disabled");
						$("#data").html('<div class="alert alert-danger">' + lang_there_was_an_error + '.</div>');
					},
					success: function(data){
						if(data.status == 'success') {
							finished = true;
							$("#data").html('<div class="alert alert-success"><strong>' + lang_all_finished + ' - <a href="' + data.msg + '">' + lang_login_to_setup_your_ad + '</a></strong></div>');
						} else if(data.status == 'error') {
							$("#data").html('<div class="alert alert-danger">' +
									data.msg + '</div>');
						} else if(data.status == 'warning') {
							finished = true;
							$("#data").html('<div class="alert alert-warning">' + data.msg + '</div><div class="alert alert-success"><strong>' + lang_all_finished + ' - <a href="index.php?login">' + lang_login_to_setup_your_ad + '</a></strong></div>');
						}
						$("#next").attr("disabled", "disabled").toggleClass("disabled");

					},
					dataType: 'json',
					resetForm: false
				},
				validationOptions: {
					rules: {
						mail: {
							required: true,
							email: true
						},
						password: {
							minlength: 6
						},
						pass2: {
							minlength: 6,
							equalTo: "#password"
						}
					},
					errorClass: 'help-block',
					errorElement: 'span',
					highlight: function(element, errorClass, validClass) {
						$(element).parents('.form-group').removeClass('has-success').addClass('has-error');
					},
					unhighlight: function(element, errorClass, validClass) {
						$(element).parents('.form-group').removeClass('has-error').addClass('has-success');
					}
				}
			}
	);

});