function HideShowSMTP(){
	if ($('#mail_type').val() == '1'){
		$('#smtp_settings').hide();
	} else {
		$('#smtp_settings').show();
	}
}

$(function () {
	$(".tips").tooltip({placement: 'auto left'});
	$(':checkbox').bootstrapSwitch();
	$(".chzn-select").chosen();
	$('#site_theme').ddslick();

	$('#site_template').ddslick({
		onSelected: function(selectedData){
			$.getJSON("index.php?config&themes&" + selectedData.selectedData.value, function(data) {
				$('#site_theme').ddslick({
					data:data
				});
			});
		}
	});

	HideShowSMTP();
	$('#mail_type').change(function() {
		HideShowSMTP();
	});

	$('#geoip_update').click(function() {
		$.ajax({
			dataType: "json",
			url: "index.php?config&geoip&update",
			beforeSend: function() {
				$('#geoip_update_result').html(checking);
			}
		})
				.done(function( data ) {
					$('#geoip_update_result').html(data);
				});
		return false;
	});

	$('#db_backup').click(function() {
		$.ajax({
			dataType: "json",
			url: "index.php?config&db&backup",
			beforeSend: function() {
				$('#db_backup_result').html(processing);
			}
		})
		.done(function( data ) {
				$('#db_backup_result').html(data);
		});
		return false;
	});

	$('#mysa_update').click(function() {
		$.ajax({
			dataType: "json",
			url: "index.php?config&mysa&update",
			beforeSend: function() {
				$('#mysa_update_result').html(checking);
			}
		})
		.done(function( data ) {
			$('#mysa_update_result').html(data);
		});
		return false;
	});

	$('#clean_cache').click(function() {
		$.ajax({
			dataType: "json",
			url: "index.php?config&cache&clean",
			beforeSend: function() {
				$('#clean_cache_result').html(processing);
			}
		})
				.done(function( data ) {
					$('#clean_cache_result').html(data);
				});
		return false;
	});

	$("form").validate({
		rules: {
			site_logo_url:{
				url: true
			},
			mail_from_email:{
				email: true
			},
			mail_smtp_port:{
				integer: true,
				min: 0
			}
		},
		highlight: function (element) {
			$(element).closest('.form-group').removeClass('has-success').addClass('has-error');
		},
		unhighlight: function (element) {
			$(element).closest('.form-group').removeClass('has-error').addClass('has-success');
		}
	});

});
