<?php

/** @var $f3 \Base */
$f3=require('../f3/lib/base.php');

//Config
$f3->config('../config.php');
$f3->config('app/adminconfig.php');

//DB
$db = new \DB\SQL('mysql:host='.$f3->get('db_host').';dbname='.$f3->get('db_name'),$f3->get('db_username'), $f3->get('db_password'));
$f3->set('DB', $db);
//new DB\SQL\Session($db, 'mysa_sessions', false);

//Routes
$f3->route('GET /index.php?install', 'Install->getInstall');
$f3->route('POST /index.php?install', 'Install->postInstall');
$f3->route('POST /index.php?update', 'Install->postUpdate');

$f3->route('GET /index.php?login*', 'Account->getLogin', 0, 512); // limit sent data to 512 Kbps
$f3->route('POST /index.php?login*', 'Account->postLogin', 0, 512); // limit sent data to 512 Kbps
$f3->route('POST /index.php?forgotpassword', 'Account->forgotPassword', 0, 512); // limit sent data to 512 Kbps
$f3->route('GET /index.php?logout', 'Account->logout', 0, 512); // limit sent data to 512 Kbps

$f3->route('GET /', 'Dashboard->getIndex');
$f3->route('GET /index.php', 'Dashboard->getIndex');
$f3->route('GET /index.php?dashboard&chartdata&@type', 'Dashboard->getChartData');

$f3->route('GET /index.php?ads', 'Ads->getIndex');
$f3->route('GET /index.php?ads&list', 'Ads->getIndex');
$f3->route('GET /index.php?ads&create', 'Ads->getCreateSelect');
$f3->route('GET /index.php?ads&create&@type', 'Ads->getCreate');
$f3->route('POST /index.php?ads&create&@type', 'Ads->postCreate');
$f3->route('GET /index.php?ads&edit&@id', 'Ads->getEdit');
$f3->route('POST /index.php?ads&edit&@id', 'Ads->postEdit');
$f3->route('POST /index.php?ads&delete&@id', 'Ads->postDelete');
$f3->route('GET /index.php?ads&code&@id', 'Ads->getCodes');
$f3->route('GET /index.php?ads&getcode&@id&@type&@keywords [ajax]', 'Ads->getCode');
$f3->route('GET /index.php?ads&getimages&@type [ajax]', 'Ads->getImages');
$f3->route('GET /index.php?ads&preview&@id [ajax]', 'Ads->previewAd');

$f3->route('GET /index.php?geo&getregions&@cc [ajax]', 'Ads->getRegions');
$f3->route('GET /index.php?geo&getcities&@rc [ajax]', 'Ads->getCities');

$f3->route('POST /index.php?ads&upload&@type&@id', 'Ads->postUpload');

$f3->route('GET /index.php?groups', 'Groups->getIndex');
$f3->route('GET /index.php?groups&list', 'Groups->getIndex');
$f3->route('GET /index.php?groups&create', 'Groups->getCreate');
$f3->route('POST /index.php?groups&create', 'Groups->postCreate');
$f3->route('GET /index.php?groups&edit&@id', 'Groups->getEdit');
$f3->route('POST /index.php?groups&edit&@id', 'Groups->postEdit');
$f3->route('POST /index.php?groups&delete&@id', 'Groups->postDelete');
$f3->route('GET /index.php?groups&code&@id', 'Groups->getCodes');
$f3->route('GET /index.php?groups&getcode&@id&@type&@keywords [ajax]', 'Groups->getCode');

$f3->route('GET /index.php?users', 'Users->getIndex');
$f3->route('GET /index.php?users&list', 'Users->getIndex');
$f3->route('GET /index.php?users&create', 'Users->getCreate');
$f3->route('POST /index.php?users&create', 'Users->postCreate');
$f3->route('GET /index.php?users&edit&@id', 'Users->getEdit');
$f3->route('POST /index.php?users&edit&@id', 'Users->postEdit');
$f3->route('POST /index.php?users&delete&@id', 'Users->postDelete');

$f3->route('GET /index.php?sales', 'Sales->getIndex');
$f3->route('GET /index.php?sales&list', 'Sales->getIndex');
$f3->route('GET /index.php?sales&create', 'Sales->getCreate');
$f3->route('POST /index.php?sales&create', 'Sales->postCreate');
$f3->route('GET /index.php?sales&edit&@id', 'Sales->getEdit');
$f3->route('POST /index.php?sales&edit&@id', 'Sales->postEdit');
$f3->route('POST /index.php?sales&upload', 'Sales->postUpload');
$f3->route('POST /index.php?sales&delete&@id', 'Sales->postDelete');
$f3->route('GET /index.php?sales&code&@id', 'Sales->getCodes');
$f3->route('GET /index.php?sales&getcode&@id&@type', 'Sales->getCode');

$f3->route('GET /index.php?spots&@url', 'Spots->getIndex');
$f3->route('GET /index.php?spots&@url&@token', 'Spots->getIndex');
$f3->route('POST /index.php?spots&buy&@id&@qty&@method [ajax]', 'Spots->postPurchase');
$f3->route('GET /index.php?spots&return&buy&@id&@qty&@token&@payerid', 'Spots->getPurchaseReturn');
$f3->route('GET /index.php?spots&return&buy&@id&@qty&@token&@payerid&@method', 'Spots->getPurchaseReturn');
//$f3->route('GET /index.php?spots&return&buy&@id&@qty&@method&@token [ajax]', 'Spots->postPurchaseReturn');
$f3->route('POST /index.php?spots&buy&account&email&check [ajax]', 'Spots->postCheckExistingAccount');
$f3->route('POST /index.php?spots&buy&account&setup&@saleid&@salerecordid [ajax]', 'Spots->postPurchaseAccount');

$f3->route('GET /index.php?stats', 'Stats->getIndex');
$f3->route('POST /index.php?stats', 'Stats->postIndex');

$f3->route('GET /index.php?config', 'Configs->getEdit');
$f3->route('POST /index.php?config', 'Configs->postEdit');
$f3->route('GET /index.php?config&themes&@template [ajax]', 'Configs->getThemesOptions');
$f3->route('GET /index.php?config&geoip&update [ajax]', 'Configs->getGeoIpDatabaseUpdate');
$f3->route('GET /index.php?config&db&backup [ajax]', 'Configs->getDatabaseBackup');
$f3->route('GET /index.php?config&mysa&update [ajax]', 'Configs->getMysaUpdate');
$f3->route('GET /index.php?config&cache&clean [ajax]', 'Configs->getCleanCache');
$f3->route('GET /index.php?config&cache&clean', 'Configs->getCleanCache');

$f3->route('GET /index.php?profile', 'Profiles->getEdit');
$f3->route('POST /index.php?profile', 'Profiles->postEdit');

$f3->route('GET /index.php?include', 'Controller->IncludeAsset');


/* Testing Routes */

$f3->route('GET /index.php?test&getinstall', 'InstallTest->getInstall');
$f3->route('GET /index.php?test&postinstall', 'InstallTest->postInstall');

$f3->route('GET /index.php?test&getlogin', 'AccountTest->getLogin', 0, 512);
$f3->route('GET /index.php?test&postlogin', 'AccountTest->postLogin', 0, 512);

$f3->route('GET /index.php?test&ads&postcreate&@type&@sale', 'Adtest->postCreate');
$f3->route('GET /index.php?test&ads&getsendadLimitreachedadmin', 'Adtest->getSendAdLimitReachedAdmin');
$f3->route('GET /index.php?test&ads&getsendweeklystats', 'Adtest->getSendWeeklyStats');

$f3->route('GET /index.php?test&groups&postcreate', 'Grouptest->postCreate');

$f3->route('GET /index.php?test&sales&postcreate', 'Saletest->postCreate');
$f3->route('GET /index.php?test&sales&postcreatesalesrecord', 'Saletest->postCreateSaleRecord');
$f3->route('GET /index.php?test&sales&getsendadvertiserspotpurchase', 'Saletest->getSendAdvertiserSpotPurchase');
$f3->route('GET /index.php?test&sales&getsendadlimitreachedadvertiser', 'Saletest->getSendAdLimitReachedAdvertiser');

$f3->route('GET /index.php?test&users&postcreate', 'Usertest->postCreate');

$f3->route('GET /index.php?test&q&add', 'Statsqtest->addToQueue');

$f3->route('GET /index.php?test&q&pq', 'Statsqtest->processQueue');

$f3->run();

/** Returns file path with proper ui path prepended
 * @param $file string Full asset file path from the defined UI dir
 * @return string
 */
function IncludeAsset($file){
	$f3 = Base::instance();
	$ui = $f3->get('UI');
	$uiExploded = explode(';', $ui);
	foreach ($uiExploded as $currentUi) {
		if (file_exists(dirname(__FILE__).'/'.$currentUi.$file)){
			return $currentUi.$file;
		}
	}
	return $uiExploded[count($uiExploded) - 1];
}

/* For Testing */

function displayError($string){
	echo '<br /><span style="color:red">Error: ('.$string.'</span>)<br />';
}

function displayResults($test){
	// Display the results; not MVC but let's keep it simple
	foreach ($test->results() as $result) {
		echo $result['text'].'<br />';
		if ($result['status'])
			echo '<span style="color:green">Pass</span>';
		else
			echo '<span style="color:red">Fail ('.$result['source'].'</span>)';
		echo '<br />';
	}
}