<?php

namespace Models;

class User extends DB_Resource {

	protected
			$fieldConf = array(
			'username' => array(
					'type' => 'VARCHAR128',
					'nullable'=>false,
			),
			'enabled' => array(
					'type' => 'BOOLEAN',
					'default' => 1,
					'nullable' => false,
			),
			'notes' => array(
					'type' => 'TEXT',
			),
			'api' => array(
					'type' => 'VARCHAR128',
			),
			'password' => array(
					'type' => 'VARCHAR256',
			),
			'mail' => array(
					'type' => 'VARCHAR256',
			),
			'receive_mail' => array(
					'type' => 'BOOLEAN',
					'default' => 1,
					'nullable' => false,
			),
			'role' => array(
					'type' => 'INT1',
					'default' => 1,
					'nullable' => false,
			),
			'psid' => array(
					'type' => 'VARCHAR128',
					'default' => '',
			),
			'last_login' => array(
					'type' => 'INT4',
			),
			'last_updated' => array(
					'type' => 'INT4',
			),
	),
			$table = 'users';


	/**
	 * check if username already exists
	 * @param $val
	 * @return null
	 */
	public function set_username($val) {
		if($this->dry())
			// new
			$user = $this->findone(array('username = ?',$val));
		else // existing
			$user = $this->findone(array('username = ? and _id != ?',$val,$this->_id));
		if($user) {
			$val = NULL;
			if (\FlashMessage::instance()->getKey('form.username') == ''){
				$f3 = \Base::instance();
				\FlashMessage::instance()->setKey('form.username','has-error');
				\FlashMessage::instance()->addMessage($f3->get('lang_this_username_already_exists'),'warning');
				\Utils::Logger('[set_username]Added Message:'.$f3->get('lang_this_username_already_exists'));
			}
		}
		return $val;
	}

	/**
	 * crypt password
	 * @param $val
	 * @return string
	 */
	public function set_password($val) {
		if ($val == $this->password) return $val;
		if (empty($val)) return $val;
		//$crypt = \Bcrypt::instance();
		//return $crypt->hash($val);
		$ph = new \PasswordHash(8, false);
		return $ph->HashPassword($val);
	}

	/**
	 * verify password
	 * @param $password
	 * @param $hashed_password
	 * @return string
	 */
	public function verify_password($password, $hashed_password) {
		$ph = new \PasswordHash(8, false);
		return $ph->CheckPassword($password, $hashed_password);
	}

	/**
	 * validate email address
	 * @param $val
	 * @return null
	 */
	public function set_mail($val) {
		if(!empty($val) && !\Audit::instance()->email($val,false)) {
			$val = NULL;
			if (\FlashMessage::instance()->getKey('form.mail') == ''){
				\FlashMessage::instance()->addMessage('The entered email address is not valid.', 'warning');
				\FlashMessage::instance()->setKey('form.mail', 'has-error');
			}
		}elseif(empty($val)){
			$val = NULL;
		}
		return $val;
	}

	public function set_enabled($value = null){
		if ($value == null) return 1;
		return $value;
	}

	/**
	 * @param null $value
	 * @return int|null
	 */
	public function set_notes($value = null){
		if ($value == '<p><br></p>') return ('');
		return $value;
	}

	public function getSingle($f3, $params)
	{
		if (isset($params['id']))
			$this->response->data['content'] = $this->load(array('_id = ?', $params['id']));
		if ($this->dry())
			$f3->error(404, 'User not found');
	}

	public function getList($f3,$param) {
		$this->response->data = array(
				'content' => $this->find(),
		);
	}

	public static function getRoles(){
		$f3 = \Base::instance();
		$roles = array();
		$roles[] = new Role(1, $f3->get('lang_advertiser'));
		$roles[] = new Role(8, $f3->get('lang_admin'));
		$roles[] = new Role(9, $f3->get('lang_super_admin'));

		return ($roles);
	}

	public static function getRoleName($role_id){
		$f3 = \Base::instance();
		switch ($role_id){
			case 1:
				return $f3->get('lang_advertiser');
				break;
			case 8:
				return $f3->get('lang_admin');
				break;
			case 9:
				return $f3->get('lang_super_admin');
				break;
		}
		return '';
	}

}

class Role {

	public function __construct($id, $name) {
		$this->id = $id;
		$this->name = $name;
	}

	public $id = 0;

	public $name = '';
}
