<?php

namespace Models;


/**
 * Class Schedule
 * @param $f3 \Base
 * @package Models
 */
class Schedule extends DB_Resource {

	protected
			$fieldConf = array(
			'status' => array(
					'type' => 'BOOLEAN',
					'default' => 1,
					'nullable' => false,
			),
			'frequency' => array(
					'type' => 'INT2',
			),
			'job' => array(
					'type' => 'VARCHAR128',
			),
			'last_run_time' => array(
					'type' => 'INT4',
			),
			'last_run_result' => array(
					'type' => 'VARCHAR128',
			),
	),
			$table = 'schedule';

	/**
	 * setup / update table schema
	 * @static
	 * @param $db
	 * @param $table
	 * @param $fields
	 * @return bool
	 */
	static public function setup($db=null, $table=null, $fields=null){
		parent::setup();

		$s = new \Models\Schedule();
		$s->frequency = 30;
		$s->job = 'limiter';
		$s->last_run_time = time();
		$s->save();

		$s = new \Models\Schedule();
		$s->frequency = 350;
		$s->job = 'group_click_sort';
		$s->last_run_time = time();
		$s->save();

		$s = new \Models\Schedule();
		$s->frequency = 10080;
		$s->job = 'weekly_emailer';
		$s->last_run_time = time();
		$s->save();

		$s = new \Models\Schedule();
		$s->frequency = 720;
		$s->job = 'cleaner';
		$s->last_run_time = time();
		$s->save();
	}

}