<?php

namespace Models;

class Sale extends DB_Resource {

	protected
			$fieldConf = array(
			'title' => array(
					'type' => 'VARCHAR256',
					'default' => '',
					'nullable' => false,
					'required' => true,
			),
			'notes' => array(
					'type' => 'TEXT',
			),
			'status' => array(
					'type' => 'BOOLEAN',
					'default' => 1,
					'nullable' => false,
			),
			'banners_width' => array(
					'type' => 'INT2'
			),
			'banners_height' => array(
					'type' => 'INT2'
			),
			'pricing_cost' => array(
					'type' => 'DOUBLE'
			),
			'pricing_type' => array(
					'type' => 'VARCHAR128',
					'nullable'=>false,
					'required'=>true,
			),
			'pricing_currency' => array(
					'type' => 'VARCHAR128',
					'nullable'=>false,
					'required'=>true,
			),
			'max_spots' => array(
					'type' => 'INT2',
					'default' => 1,
					'nullable'=>false,
					'required'=>true,
			),
			'type' => array(
					'type' => 'VARCHAR128',
					'nullable' => false,
					'default' => '',
					'required' => true,
			),
			'site_name' => array(
					'type' => 'VARCHAR256',
					'required' => true,
			),
			'site_url' => array(
					'type' => 'VARCHAR256',
					'required' => true,
			),
			'site_contact_url' => array(
					'type' => 'VARCHAR256',
			),
			'site_key' => array(
					'type' => 'VARCHAR128',
			),
			'spot_image_url' => array(
					'type' => 'VARCHAR256',
			),
			'default_weight' => array(
					'type' => 'INT1',
					'default' => 10,
			),
			'fill_group' => array(
					'belongs-to-one' => '\Models\Group',
			),
			'ads' => array(
					'has-many' => array('\Models\Ad','sale'),
			),
			'user_id' => array(
					'belongs-to-one' => '\Models\User',
			),
			'last_updated' => array(
					'type' => 'INT4',
			),
	),
			$table = 'sales';


	/**
	 * @param null $value
	 * @return bool|null
	 */
	public function get_pricing_cost($value = null){
		return number_format((float)$value, 2, '.', '');
	}

	/**
	 * @param null $value
	 * @return bool|null
	 */
	public function get_status($value = null) {
		return ($value === 0 ? 0 : 1);
	}

	/**
	 * @param null $value
	 * @return bool|null
	 */
	public function get_max_spots($value = null) {
		if ($value == null) {
			return 1;
		} else {
			return ($value);
		}
	}

	/**
	 * @param null $value
	 * @return int|null
	 */
	public function set_site_url($value = null){
		try {
		$this->site_key = md5(strtolower(trim($value)));
		} catch (\Exception $e){
			\Utils::Logger('set_site_key:Error setting - '.$e);
		}
		return ($value);
	}

	/**
	 * @param null $value
	 * @return int|null
	 */
	public function set_notes($value = null){
		if ($value == '<p><br></p>') return ('');
		return $value;
	}

	/**
	 * @param null $value
	 * @return int|null
	 */
	public function get_default_weight($value = null) {
		if ($value == null) {
			return 10;
		} else {
			return ($value);
		}
	}
}
