<?php

namespace Models;


/**
 * Class Ad
 * @param $f3 \Base
 * @package Models
 */
class Ad extends DB_Resource {

	protected
			$fieldConf = array(
			'title' => array(
					'type' => 'VARCHAR256',
					'default' => '',
					'nullable' => false,
					'required' => true,
			),
			'notes' => array(
					'type' => 'TEXT',
			),
			'status' => array(
					'type' => 'BOOLEAN',
					'default' => 1,
					'nullable' => false,
			),
			'approved' => array(
					'type' => 'BOOLEAN',
					'default' => 1,
					'nullable' => false,
			),
			'type' => array(
					'type' => 'VARCHAR128',
					'nullable' => false,
					'default' => '',
					'required' => true,
			),
			'start_date' => array(
					'type' => 'INT4',
			),
			'end_date' => array(
					'type' => 'INT4',
			),
			'type_freeform' => array(
					'type' => 'BLOB',
			),
			'type_banner' => array(
					'type' => 'BLOB'
			),
			'type_textlink' => array(
					'type' => 'BLOB'
			),
			'type_video' => array(
					'type' => 'BLOB'
			),
			'geo_countries' => array(
					'type' => 'VARCHAR256',
			),
			'geo_regions' => array(
					'type' => 'TEXT',
			),
			'geo_cities' => array(
					'type' => 'VARCHAR256',
			),
			'geo_onoff' => array(
					'type' => 'INT1',
					'nullable' => false,
					'default' => 0,
			),
			'impressions_limit_num' => array(
					'type' => 'INT4',
			),
			'clicks_limit_num' => array(
					'type' => 'INT4',
			),
			'limit_time' => array(
					'type' => 'INT4',
			),
			'limit_start_date' => array(
					'type' => 'INT4',
			),
			'limit_reached_date' => array(
					'type' => 'INT4',
			),
			'weight' => array(
					'type' => 'INT1',
					'default' => 5,
			),
			'last_updated' => array(
					'type' => 'INT4',
			),
			'advertiser' => array(
					'belongs-to-one' => '\Models\User',
			),
			'user_id' => array(
					'belongs-to-one' => '\Models\User',
			),
			'sale' => array(
					'belongs-to-one' => '\Models\Sale',
			),
			'sale_record' => array(
					'belongs-to-one' => '\Models\Salerecord',
			),
			'groups' => array(
					'has-many' => array('\Models\Group', 'ads'),
			),
			'keywords' => array(
					'has-many' => array('\Models\Keyword', 'ads'),
			),
	),
			$table = 'ads';

	public function set_keywords($value = null){
		if (empty($value)) return $value;

		$keyArr = \Base::instance()->split($value);
		$key_res = new Keyword();

		// Find IDs of known Keywords
		$known_keys = $key_res->find(array('keyword IN ?', $keyArr));
		$keys = array();
		if ($known_keys){
			foreach ($known_keys as $key){
				$keys[$key->_id] = $key->keyword;
			}
			$newKeys = array_diff($keyArr, array_values($keys));
		} else
			$newKeys = $keyArr;

		foreach ($newKeys as $key){
			$key_res->reset();
			$key_res->keyword = $key;
			$out = $key_res->save();
			$keys[$out->_id] = $out->keyword;
		}
		$value = array_keys($keys);
		return $value;
	}

	/**
	 * @param null $value
	 * @return bool|null
	 */
	public function get_keywords($value = null){
		if (empty($value)) return $value;

		$return = '';
		foreach ($value as $key){
			$return .= $key['keyword'].',';
		}

		return(trim($return, ','));
	}


	/**
	 * @param null $value
	 * @return bool|null
	 */
	public function get_status($value = null) {
		return ($value === 0 ? 0 : 1);
	}


	/**
	 * @param null $value
	 * @return int|null
	 */
	public function get_weight($value = null) {
		if ($value == null) {
			return 5;
		} else {
			return ($value);
		}
	}

	/**
* @param null $value
* @return int|null
*/
	public function set_notes($value = null){
		if ($value == '<p><br></p>') return ('');
		return $value;
	}


	/**
	 * @param null $value
	 * @return array
	 */
	public function get_geo_countries($value = null){
		if ($value == null) return array();
		return (explode(',', $value));
	}

	/**
	 * @param null $value
	 * @return array|null
	 */
	public function get_geo_regions($value = null){
		if ($value == null) return null;
		return (explode(',', $value));
	}

	/**
	 * @param null $value
	 * @return array|null
	 */
	public function get_geo_cities($value = null){
		if ($value == null) return null;
		return (explode(',', $value));
	}

	/**
	 * @param null $value
	 * @return bool|string
	 */
	public function get_impressions_limit_num($value = null){
		if ($value == 0) return null;
		return $value;
	}

	/**
	 * @param null $value
	 * @return bool|string
	 */
	public function get_clicks_limit_num($value = null){
		if ($value == 0) return null;
		return $value;
	}

	/**
	 * @param null $value
	 * @return bool|string
	 */
	public function get_limit_time($value = null){
		if ($value == 0) return null;
		return $value;
	}

	/**
	 * @param null $value
	 * @return bool|string
	 */
	public function get_start_date($value = null){
		if ($value == null) {
			return '';
		} elseif ($value <= 0) {
			return '';
		} else {
			return (date("Y-m-d", $value));
		}
	}

	/**
	 * @param null $value
	 * @return int|null|string
	 */
	public function set_start_date($value = null){
		if ($value == null) {
			return 0;
		} elseif ($value <= 0) {
			return $value;
		} else {
			$dateTime = \DateTime::createFromFormat('!Y-m-d', $value);
			if ($dateTime->format('U') > time()) $this->status = 0;
			return ($dateTime->format('U'));
		}
	}

	/**
	 * @param null $value
	 * @return bool|string
	 */
	public function get_end_date($value = null){
		if ($value == null) {
			return '';
		} elseif ($value <= 0) {
			return '';
		} else {
			return (date("Y-m-d", $value));
		}
	}

	/**
	 * @param null $value
	 * @return int|null|string
	 */
	public function set_end_date($value = null){
		if ($value == null) {
			return 0;
		} elseif ($value <= 0) {
			return $value;
		} else {
			$dateTime = \DateTime::createFromFormat('!Y-m-d', $value);
			return ($dateTime->format('U'));
		}
	}

	/**
	 * @param null $value
	 * @return \Types\Freeform
	 */
	public function get_type_freeform($value = null) {
		$t = new \Types\Freeform();
		if ($value == null) return ($t);
		$data = json_decode($value);
		foreach ($data as $key => $val) {
			if (property_exists($t, $key)) {
				$t->$key = $val;
			}
		}
		return ($t);
	}

	/**
	 * @param null $value
	 * @return string|\Types\Freeform
	 */
	public function set_type_freeform($value = null) {
		$f3 = \Base::instance();
		$data = $f3->get('POST');
		if ($data== null) return (null);
		if ($data['type'] != 'freeform') return (null);
		$t = new \Types\Freeform();
		foreach ($data as $key => $val) {
			if (property_exists($t, $key)) {
				$t->$key = $val;
			}
		}
		return (json_encode($t));
	}


	/**
	 * @param null $value
	 * @return \Types\Banner
	 */
	public function get_type_banner($value = null) {
		$t = new \Types\Banner();
		if ($value == null) return ($t);
		$data = json_decode($value);
		foreach ($data as $key => $val) {
			if (property_exists($t, $key)) {
				$t->$key = $val;
			}
		}
		return ($t);
	}

	/**
	 * @param null $value
	 * @return string|\Types\Banner
	 */
	public function set_type_banner($value = null) {
		$f3 = \Base::instance();
		$data = $f3->get('POST');
		if ($data== null) return (null);
		if ($data['type'] != 'banner') return (null);
		$t = new \Types\Banner();
		foreach ($data as $key => $val) {
			if (property_exists($t, $key)) {
				$t->$key = $val;
			}
		}
		return (json_encode($t));
	}

	/**
	 * @param null $value
	 * @return \Types\TextLink
	 */
	public function get_type_textlink($value = null) {
		$t = new \Types\TextLink();
		if ($value == null) return ($t);
		$data = json_decode($value);
		foreach ($data as $key => $val) {
			if (property_exists($t, $key)) {
				$t->$key = $val;
			}
		}
		return ($t);
	}

	/**
	 * @param null $value
	 * @return string|\Types\TextLink
	 */
	public function set_type_textlink($value = null) {
		$f3 = \Base::instance();
		$data = $f3->get('POST');
		if ($data== null) return (null);
		if ($data['type'] != 'textlink') return (null);
		$t = new \Types\Textlink();
		foreach ($data as $key => $val) {
			if (property_exists($t, $key)) {
				$t->$key = $val;
			}
		}
		return (json_encode($t));
	}

	/**
	 * @param null $value
	 * @return \Types\Video
	 */
	public function get_type_video($value = null) {
		$t = new \Types\Video();
		if ($value == null) return ($t);
		$data = json_decode($value);
		foreach ($data as $key => $val) {
			if (property_exists($t, $key)) {
				$t->$key = $val;
			}
		}
		return ($t);
	}

	/**
	 * @param null $value
	 * @return string|\Types\Video
	 */
	public function set_type_video($value = null) {
		$f3 = \Base::instance();
		$data = $f3->get('POST');
		if ($data== null) return (null);
		if ($data['type'] != 'video') return (null);
		$t = new \Types\Video();
		foreach ($data as $key => $val) {
			if (property_exists($t, $key)) {
				$t->$key = $val;
			}
		}
		return (json_encode($t));
	}

}
