<?php

class Queue extends Controller {


	/**
	 * @param $f3 \Base
	 */
	public function processQueue($f3){
		set_time_limit(180);

		$sql = 'SELECT * FROM mysa_stats_q ORDER BY id ASC LIMIT 1000';
		$rows = $f3->get('DB')->exec($sql);
		if (empty($rows)) {echo 'no records to process.'; return;}
		if (count($rows) <= 0) {echo 'no records to process.'; return;}

		$q_id = 0;
		$count = 0;
		foreach ($rows as $q){

			$q_id = $q['id'];
			$q_date = date('Ymd', $q['dt']);

			if (!empty($q['ad_id'])){
				$stat_ad_res = new \Apimodels\Statad();
				$stat_ad = $stat_ad_res->findone(array('date = ? and ad_id = ?',$q_date,$q['ad_id']));

				if ($stat_ad){
					$general = $this->_processGeneral($q, $stat_ad );
					$stat_ad->uniques += $q['u'];
					$stat_ad->impressions += $q['i'];
					$stat_ad->clicks += $q['c'];
				} else {
					$stat_ad = new \Apimodels\Statad();
					$general = $this->_processGeneral($q, $stat_ad );

					$stat_ad->date = $q_date;
					$stat_ad->ad_id = $q['ad_id'];
					$stat_ad->uniques = $q['u'];
					$stat_ad->impressions = $q['i'];
					$stat_ad->clicks = $q['c'];
				}
				$stat_ad->browsers = $general['browsers'];
				$stat_ad->hostnames = $general['hostnames'];
				$stat_ad->referers = $general['referers'];
				$stat_ad->devices = $general['devices'];
				$stat_ad->oss = $general['oss'];
				$stat_ad->geos = $general['geos'];
				$stat_ad->save();
				$count++;
				continue;
			}


			if (!empty($q['group_id'])){

				$stat_group_res = new \Apimodels\Statgroup();
				$stat_group = $stat_group_res->findone(array('date = ? and group_id = ?',$q_date,$q['group_id']));

				if ($stat_group){

					$stat_group->uniques += $q['u'];
					$stat_group->impressions += $q['i'];
				} else {
					$stat_group = new \Apimodels\Statgroup();

					$stat_group->date = $q_date;
					$stat_group->group_id = $q['group_id'];
					$stat_group->uniques = $q['u'];
					$stat_group->impressions = $q['i'];
				}

				$stat_group->save();

				$count++;
				continue;
			}


			if (!empty($q['keyword_id'])){

				$stat_keyword_res = new \Apimodels\Statkeyword();
				$stat_keyword = $stat_keyword_res->findone(array('date = ? and keyword_id = ?',$q_date,$q['keyword_id']));

				if ($stat_keyword){

					$stat_keyword->uniques += $q['u'];
					$stat_keyword->impressions += $q['i'];
				} else {
					$stat_keyword = new \Apimodels\Statkeyword();

					$stat_keyword->date = $q_date;
					$stat_keyword->keyword_id = $q['keyword_id'];
					$stat_keyword->uniques = $q['u'];
					$stat_keyword->impressions = $q['i'];
				}

				$stat_keyword->save();

				$count++;
				continue;
			}


			if (!empty($q['site_key'])){

				$stat_landingpage_res = new \Apimodels\Statlandingpage();
				$stat_landingpage = $stat_landingpage_res->findone(array('date = ? and site_key = ?',$q_date,$q['site_key']));

				if ($stat_landingpage){
					$general = $this->_processGeneral($q, $stat_landingpage );

					$stat_landingpage->uniques += $q['u'];
					$stat_landingpage->impressions += $q['i'];
				} else {
					$stat_landingpage = new \Apimodels\Statlandingpage();
					$general = $this->_processGeneral($q, $stat_landingpage );

					$stat_landingpage->date = $q_date;
					$stat_landingpage->site_key = $q['site_key'];
					$stat_landingpage->uniques = $q['u'];
					$stat_landingpage->impressions = $q['i'];
				}
				$stat_landingpage->browsers = $general['browsers'];
				$stat_landingpage->hostnames = $general['hostnames'];
				$stat_landingpage->referers = $general['referers'];
				$stat_landingpage->devices = $general['devices'];
				$stat_landingpage->oss = $general['oss'];
				$stat_landingpage->geos = $general['geos'];

				$stat_landingpage->save();

				$count++;
				continue;
			}


			if (!empty($q['sale_id'])){

				$stat_sale_res = new \Apimodels\Statsale();
				$stat_sale = $stat_sale_res->findone(array('date = ? and sale_id = ?',$q_date,$q['sale_id']));

				if ($stat_sale){
					$stat_sale->clicks += $q['c'];
				} else {
					$stat_sale = new \Apimodels\Statsale();

					$stat_sale->date = $q_date;
					$stat_sale->sale_id = $q['sale_id'];
					$stat_sale->clicks = $q['c'];
				}

				$stat_sale->save();

				$count++;
				continue;
			}

		}

		if ($q_id > 0){
			$statq_res = new \Apimodels\Statq();
			$statq_res->erase(array('_id <= ?', $q_id));
		}
		echo $count.' records processed.';
	}

	/**
	 * @param $q \Apimodels\Statq Pass in the queue and current stat object (ad, etc) and it will return an array to populate the general settings of the stat object
	 * @param $stat_object
	 * @return array
	 */
	private function _processGeneral(&$q, $stat_object){

		$general = array('browsers' => null,
				'devices' => null,
				'oss' => null,
				'hostnames' => null,
				'referers' => null,
				'geos' => null
		);

		$browserDetection = new Browserdetection();

		//Browser + OS
		if (!empty($q->agent)){
			$browserArray = $browserDetection->get_browser_info('',$q['agent']);
			$ua_browser = $browserArray['name'];
			$ua_os = $browserArray['platform'];
			$ua_device = $browserArray['type'];

			$browsers = $stat_object->browsers;
			if ($browsers == null){
				$browsers[$ua_browser] = 1;
			} else {
				if (property_exists($browsers, $ua_browser)){
					$browsers->{$ua_browser} += 1;
				} else {
					$browsers->{$ua_browser} = 1;
				}
			}
			$general['browsers'] = json_encode($browsers);

			$devices = $stat_object->devices;
			if ($devices == null){
				$devices[$ua_device] = 1;
			} else {
				if (property_exists($devices, $ua_device)){
					$devices->{$ua_device} += 1;
				} else {
					$devices->{$ua_device} = 1;
				}
			}
			$general['devices'] = json_encode($devices);

			$oss = $stat_object->oss;
			if ($oss == null){
				$oss[$ua_os] = 1;
			} else {
				if (property_exists($oss, $ua_os)){
					$oss->{$ua_os} += 1;
				} else {
					$oss->{$ua_os} = 1;
				}
			}
			$general['oss'] = json_encode($oss);

		}

		//Hostname
		if (!empty($q['hostname'])){
			$bits = parse_url($q['hostname']);
			$hostname = '';
			if (array_key_exists('host', $bits)){
				$hostname = strtolower($bits['host']);
			}
			$hostnames = $stat_object->hostnames;
			if (!empty($hostname)){
				if ($hostnames == null){
					$hostnames[$hostname] = 1;
				} else {
					if (property_exists($hostnames, $hostname)){
						$hostnames->{$hostname} += 1;
					} else {
						$hostnames->{$hostname} = 1;
					}
				}
				$general['hostnames'] = json_encode($hostnames);
			}


		}

		//Referer
		if (!empty($q['referer'])){
			$bits = parse_url($q['referer']);
			$referer = '';
			if ($bits){
				if (array_key_exists('host', $bits)){
					$referer = strtolower($bits['host']);
					if (array_key_exists('path', $bits)){
						$referer .= strtolower($bits['path']);
					}
				}
			}
			$referers = $stat_object->referers;
			if (!empty($referer)){
				if ($referers == null){
					$referers[$referer] = 1;
				} else {
					if (property_exists($referers, $referer)){
						$referers->{$referer} += 1;
					} else {
						$referers->{$referer} = 1;
					}
				}
			}
			$general['referers'] = json_encode($referers);

		}

		//Geo
		if (!empty($q['ip'])){
			$geoCode = Geolookup::GetCountyRegionCity(long2ip($q['ip']));
			$geocodes = $stat_object->geos;
			if (count($geoCode) > 0){
				if ($geocodes == null){
					$geocodes[$geoCode['country']] = 1;
					$geocodes[$geoCode['region']] = 1;
					$geocodes[$geoCode['city']] = 1;
				} else {
					$set = false;

					if (array_key_exists($geoCode['country'], $geocodes)){
						$geocodes[$geoCode['country']] += 1;
						$set = true;
					}
					if (array_key_exists($geoCode['region'], $geocodes)){
						$geocodes[$geoCode['region']] += 1;
						$set = true;
					}
					if (array_key_exists($geoCode['city'], $geocodes)){
						$geocodes[$geoCode['city']] += 1;
						$set = true;
					}

					if (!$set){
						$geocodes[$geoCode['country']] = 1;
						$geocodes[$geoCode['region']] = 1;
						$geocodes[$geoCode['city']] = 1;

					}

				}
			}
				$general['geos'] = json_encode($geocodes);

		}

		return ($general);
	}


}