$(function () { $(".tips").tooltip({placement: 'auto left'}); });
$(':checkbox').bootstrapSwitch();
$('#max_spots').TouchSpin({
	min: 0,
	max: 99
});
$('#default_weight').TouchSpin({
	min: 0,
	max: 10
});
$('#notes').summernote({
	height: "200px",
	toolbar: [
		//['style', ['style']], // no style button
		['style', ['bold', 'italic', 'underline', 'clear']],
		['fontsize', ['fontsize']],
		['color', ['color']],
		['para', ['ul', 'ol', 'paragraph']],
		//['height', ['height']],
		['table', ['table']],
		['insert', ['link']],
		['fullscreen', ['fullscreen']]

		//['help', ['help']] //no help button
	]
});

/*----------- BEGIN chosen CODE -------------------------*/
$(".chzn-select").chosen();
$(".chzn-select-deselect").chosen({
	allow_single_deselect: true
});
/*----------- END chosen CODE -------------------------*/

$(function (){
	$("form").validate({
		rules: {
			title:{
				minlength: 1,
				maxlength: 256,
				required: true
			},
			max_spots:{
				integer: true,
				required: true,
				min: 0
			},
			type:{
				required: true
			},
			pricing_cost:{
				required: true,
				number: true
			},
			pricing_type:{
				required: true
			},
			site_name:{
				required: true
			},
			site_url:{
				url: true,
				required: true
			},
			spot_image_url:{
				url: true
			}
		},
		highlight: function (element) {
			$(element).closest('.form-group').removeClass('has-success').addClass('has-error');
		},
		unhighlight: function (element) {
			$(element).closest('.form-group').removeClass('has-error').addClass('has-success');
		}
	});
});

$(function (){
	$('#type').change(function() {
		if ($(this).val() == 'banner'){
			$('#type_banner').css('display', 'inherit');
		} else {
			$('#type_banner').css('display', 'none');
		}
	});
});


$(function (){
	setTimeout(function(){
		$("input:text:visible:first").focus();
	}, 0);
});

$(function () {
	$('#fileupload_lg').fileupload({
		url: "index.php?sales&upload",
		dataType: 'json',
		autoUpload: true,
		acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
		maxFileSize: 2097152, // 2 MB
		previewMaxWidth: 100,
		previewMaxHeight: 100,
		previewCrop: true
	}).on('fileuploadadd', function (e, data) {
		data.context = $('<div/>').appendTo('#files_lg');
		$('#progress_lg').find('.progress-bar').css(
				'width',
				0 + '%'
		);
	}).on('fileuploadprocessalways', function (e, data) {
		var index = data.index,
				file = data.files[index],
				node = $(data.context.children()[index]);
		if (file.preview) {
			node
					.prepend('<br>')
					.prepend(file.preview);
		}
		if (file.error) {
			node
					.append('<br>')
					.append($('<span class="text-danger"/>').text(file.error));
		}
		if (index + 1 === data.files.length) {
			data.context.find('button')
					.text('Upload')
					.prop('disabled', !!data.files.error);
		}
	}).on('fileuploadprogressall', function (e, data) {
		var progress = parseInt(data.loaded / data.total * 100, 10);
		$('#progress_lg').find('.progress-bar').css(
				'width',
				progress + '%'
		);
	}).on('fileuploaddone', function (e, data) {
		$.each(data.result, function (index, file) {
			if (file.url) {
				$('#spot_image_url').val(file.url);
				$('#files_lg').html('<button data-src="spot_image_url" type="button" data-content="" data-toggle="popover" class="btn btn-metis-2 preview">' + preview + '</button><div data-src="spot_image_url" class="modal fade text-center" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true"></div>');
			} else if (file.error) {
				$('#spot_image_url').val("");
				var error = $('<span class="text-danger"/>').text(file.error);
				$(data.context.children()[index])
						.append('<br>')
						.append(error);
			}
		});
	}).on('fileuploadfail', function (e, data) {
		$('#spot_image_url').val("");
		$.each(data.files, function (index, file) {
			var error = $('<span class="text-danger"/>').text('File upload failed.');
			$(data.context.children()[index])
					.append('<br>')
					.append(error);
		});
	}).prop('disabled', !$.support.fileInput)
			.parent().addClass($.support.fileInput ? undefined : 'disabled');


	$('.files').on('click', '.preview', function(){

		var src = $(this).data('src');
		$('.modal[data-src=' + src + ']').html('<img src="' + $('#' + src).val() + '"/>').modal().click(function(){
			$(this).modal('hide');
		});
	});

});
