$(function() {
	var responsiveHelper;
	var breakpointDefinition = {
		tablet: 1024,
		phone : 480
	};
	var tableElement = $('#dataTable');
	/*----------- BEGIN datatable CODE -------------------------*/
	tableElement.dataTable({
		sDom: "<'pull-right'l>t<'row'<'col-lg-6'f><'col-lg-6'p>>",
		pagingType: 'full_numbers',
		aaSorting: [[ 2, "desc" ]],
		stateSave: true,
		stateDuration: 60 * 60 * 24 * 365,
		stateSaveCallback: function (settings, data) {
			localStorage.setItem('mysa_dt_sales', JSON.stringify(data));
		},
		stateLoadCallback: function (settings) {
			return (JSON.parse(localStorage.getItem('mysa_dt_sales')));
		},
		oLanguage: {
			sLengthMenu: lang_show + " _MENU_ " + lang_entries,
			sSearch: lang_search + ":",
			sZeroRecords: lang_no_listings + " - " + "<a href=\"index.php?sales&create\">" + lang_create_a_new_sales_spot + "</a>",
			oPaginate: {
				sNext: lang_next,
				sPrevious: lang_previous
			}
		},
		// Setup for responsive datatables helper.
		bAutoWidth     : false,
		fnPreDrawCallback: function () {
			// Initialize the responsive datatables helper once.
			if (!responsiveHelper) {
				responsiveHelper = new ResponsiveDatatablesHelper(tableElement, breakpointDefinition);
			}
		},
		fnRowCallback  : function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
			responsiveHelper.createExpandIcon(nRow);
		},
		fnDrawCallback : function (oSettings) {
			responsiveHelper.respond();
		}
	});
	/*----------- END datatable CODE -------------------------*/
});

//Delete
$(function() {

	$('table').on('click', 'a.delete', function() {
		var oTable = $('#dataTable').dataTable();
		var row = $(this).closest("tr").get(0);
		$('#delete').data('id', $(this).data('id')).data('row', oTable.fnGetPosition(row)).attr('disabled', false);
	});

	$('#delete').on( "click", function(e) {
		var id = $(this).data('id');
		var row = $(this).data('row');
		$(this).attr('disabled','disabled');

		$.post( "index.php?sales&delete&" + id, function( data ) {
			if (data == '1'){
				//Remove the row
				var oTable = $('#dataTable').dataTable();
				oTable.fnDeleteRow( row );
			}
			$('#deleteModal').modal('hide');
		});


	});

});