var finished = false;
$(function() {

	/*----------- BEGIN formwizard CODE -------------------------*/
	$("#wizardForm").formwizard({
		textSubmit: lang_finish,
		formPluginEnabled: true,
		validationEnabled: true,
		focusFirstInput: true,
		formOptions: {
			beforeSubmit: function(data) {
				if (finished) return false;
				$("#next").attr("disabled", "disabled");
				$("#data").html('<div class="alert alert-warning"><img src="' + ui + 'assets/img/wait.gif" alt="wait"/> ' + lang_setting_things_up + '...</div>');
				return true;
			},
			error: function(data){
				$("#next").attr("disabled", "disabled");
				$("#data").html('<div class="alert alert-danger">' + lang_there_was_an_error + '.</div>');
			},
			success: function(data){
				if(data.status == 'success') {
					finished = true;
					$("#data").html('<div class="alert alert-success"><strong>' + lang_all_finished + ' - <a href="index.php?login">' + lang_login + '</a>!</strong></div>');
				} else if(data.status == 'error') {
					$("#data").html('<div class="alert alert-danger">' + lang_there_was_an_error + ' : ' +
							data.msg + '</div>');
				} else if(data.status == 'warning') {
					finished = true;
					$("#data").html('<div class="alert alert-warning">' + data.msg + '</div><div class="alert alert-success"><strong>' + lang_all_finished + ' - <a href="index.php?login">' + lang_login + '</a>!</strong></div>');
				}
				$("#next").attr("disabled", "disabled");

			},
			dataType: 'json',
			resetForm: false
		},
		validationOptions: {
			rules: {
				username: {
					required: true,
					minlength: 3
				},
				mail: {
					required: true,
					email: true
				},
				password: {
					required: true,
					minlength: 6
				},
				pass2: {
					required: true,
					minlength: 6,
					equalTo: "#password"
				},
				purchase_account: {
					required: true,
					email: true
				}
			},
			errorClass: 'help-block',
			errorElement: 'span',
			highlight: function(element, errorClass, validClass) {
				$(element).parents('.form-group').removeClass('has-success').addClass('has-error');
			},
			unhighlight: function(element, errorClass, validClass) {
				$(element).parents('.form-group').removeClass('has-error').addClass('has-success');
			}
		}
	});
	/*----------- END formwizard CODE -------------------------*/

});