$(function () {
	$('#fileupload_lg').fileupload({
		url: "index.php?ads&upload&banner&" + ad_id,
		dataType: 'json',
		autoUpload: true,
		acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
		maxFileSize: 2097152, // 2 MB
		previewMaxWidth: 100,
		previewMaxHeight: 100,
		previewCrop: true
	}).on('fileuploadadd', function (e, data) {
		data.context = $('<div/>').appendTo('#files_lg');
		$('#progress_lg').find('.progress-bar').css(
				'width',
				0 + '%'
		);
	}).on('fileuploadprocessalways', function (e, data) {
		var index = data.index,
				file = data.files[index],
				node = $(data.context.children()[index]);
		if (file.preview) {
			node
					.prepend('<br>')
					.prepend(file.preview);
		}
		if (file.error) {
			node
					.append('<br>')
					.append($('#uploaderror').text(file.error));
		}
		if (index + 1 === data.files.length) {
			data.context.find('button')
					.text('Upload')
					.prop('disabled', !!data.files.error);
		}
	}).on('fileuploadprogressall', function (e, data) {
		var progress = parseInt(data.loaded / data.total * 100, 10);
		$('#progress_lg').find('.progress-bar').css(
				'width',
				progress + '%'
		);
	}).on('fileuploaddone', function (e, data) {
		$('#uploaderror').text('');
		$.each(data.result, function (index, file) {
			if (file.url) {
				$('#src_lg').val(file.url);
			} else if (file.error) {
				$('#src_lg').val("");
				var error = $('#uploaderror').text(file.error);
				$(data.context.children()[index])
						.append('<br>')
						.append(error);
			}
		});
	}).on('fileuploadfail', function (e, data) {
		$('#src_lg').val("");
		$.each(data.files, function (index, file) {
			var error = $('#uploaderror').text('File upload failed.');
			$(data.context.children()[index])
					.append('<br>')
					.append(error);
		});
	}).prop('disabled', !$.support.fileInput)
			.parent().addClass($.support.fileInput ? undefined : 'disabled');
});

$(function () {
	$('#fileupload_sm').fileupload({
		url: "index.php?ads&upload&banner&" + ad_id,
		dataType: 'json',
		autoUpload: true,
		acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
		maxFileSize: 2097152, // 2 MB
		previewMaxWidth: 100,
		previewMaxHeight: 100,
		previewCrop: true
	}).on('fileuploadadd', function (e, data) {
		data.context = $('<div/>').appendTo('#files_sm');
		$('#progress_sm').find('.progress-bar').css(
				'width',
				0 + '%'
		);
	}).on('fileuploadprocessalways', function (e, data) {
		var index = data.index,
				file = data.files[index],
				node = $(data.context.children()[index]);
		if (file.preview) {
			node
					.prepend('<br>')
					.prepend(file.preview);
		}
		if (file.error) {
			node
					.append('<br>')
					.append($('#uploaderror').text(file.error));
		}
		if (index + 1 === data.files.length) {
			data.context.find('button')
					.text('Upload')
					.prop('disabled', !!data.files.error);
		}
	}).on('fileuploadprogressall', function (e, data) {
		var progress = parseInt(data.loaded / data.total * 100, 10);
		$('#progress_sm').find('.progress-bar').css(
				'width',
				progress + '%'
		);
	}).on('fileuploaddone', function (e, data) {
		$.each(data.result, function (index, file) {
			if (file.url) {
				$('#src_sm').val(file.url);
			} else if (file.error) {
				$('#src_sm').val("");
				var error = $('#uploaderror').text(file.error);
				$(data.context.children()[index])
						.append('<br>')
						.append(error);
			}
		});
	}).on('fileuploadfail', function (e, data) {
		$('#src_sm').val("");
		$.each(data.files, function (index, file) {
			var error = $('#uploaderror').text('File upload failed.');
			$(data.context.children()[index])
					.append('<br>')
					.append(error);
		});
	}).prop('disabled', !$.support.fileInput)
			.parent().addClass($.support.fileInput ? undefined : 'disabled');
});

$(function () {

	$('.files').on('click', '.preview', function(){
		var src = $(this).data('src');
		var img_src = $('#' + src).val();

		var image = new Image(); // or document.createElement('img')
		var width, height;
		image.onload = function() {
			width = this.width;
			height = this.height;
			$('.modal[data-src=' + src + ']').html('<img src="' + img_src + '"/><br /><h3 style="color:#fff;">' + width + "w x " + height + 'h</h3>').modal().click(function(){
				$(this).modal('hide');
			});
		};
		image.src = img_src;

	});

	// Gallery select
	$(document.body).on('click', '.gallery_modal_select' ,function(){
		$('#modal_select').val($( this ).data('file'));
		$('#galleryModal').modal('hide')
	});

	$('#galleryModal').on('hidden.bs.modal', function () {
		var modalSelect = $('#modal_select').val();
		if (modalSelect == '') return;
		$('#' + $('#modal_size').val()).val(modalSelect);
	});

	$('.btn-gallery').click(function() {
		$('#modal_size').val($(this).data('size'));
		$.getJSON( "index.php?ads&getimages&banner", function( data ) {
				$('#galleryModalBody').html(data);
			$('#galleryModal').modal();
		});
	});



});


