$(function () { $(".tips").tooltip({placement: 'auto left'}); });
$(':checkbox').bootstrapSwitch();
$('#keywords').tagsInput({'defaultText':'', height: '75px', width: '100%'});
$('.datepicker').datepicker({format: 'yyyy-mm-dd'});
$('#weight').TouchSpin({
	min: 0,
	max: 10
});
$('#notes').summernote({
	height: "200px",
	toolbar: [
		//['style', ['style']], // no style button
		['style', ['bold', 'italic', 'underline', 'clear']],
		['fontsize', ['fontsize']],
		['color', ['color']],
		['para', ['ul', 'ol', 'paragraph']],
		//['height', ['height']],
		['table', ['table']],
		['insert', ['link']],
		['fullscreen', ['fullscreen']]

		//['help', ['help']] //no help button
	]
});

/*----------- BEGIN chosen CODE -------------------------*/
$(".chzn-select").chosen();
$(".chzn-select-deselect").chosen({
	allow_single_deselect: true
});
/*----------- END chosen CODE -------------------------*/

$(function (){
	$("form").validate({
		rules: {
			title:{
				minlength: 1,
				maxlength: 256,
				required: true
			},
			start_date:{
				date: true
			},
			end_date:{
				date: true
			},
			weight:{
				integer: true,
				required: true,
				min: 0
			},
			impressions_limit_num:{
				integer: true,
				min: 0
			},
			clicks_limit_num:{
				integer: true,
				min: 0
			},
			limit_time:{
				integer: true,
				min: 0
			},
			src_lg:{
				url: true
			},
			src_sm:{
				url: true
			},
			url:{
				url: true
			}
		},
		highlight: function (element) {
			$(element).closest('.form-group').removeClass('has-success').addClass('has-error');
		},
		unhighlight: function (element) {
			$(element).closest('.form-group').removeClass('has-error').addClass('has-success');
		}
	});
});


// Geo select enable/disable/data pull
$(function (){

	$('#geo_onoff').change(function(){
		if (($(this).val() != null) && ($(this).val() != "0")) {
			$('#geo_countries').prop("disabled", false).trigger("chosen:updated");
		} else {
			$('#geo_countries').val([]).prop("disabled", true).trigger("chosen:updated");
			$('#geo_regions').html("").prop("disabled", true).trigger("chosen:updated");
			$('#geo_cities').html("").prop("disabled", true).trigger("chosen:updated");
		}
	});

	$('#geo_countries').change(function(){

		if (($(this).val() != null) && ($(this).val().length == 1)) {
			$("#geo_regions_chosen").find('input').val('Looking up...');
			var selectitems = "";
			$.getJSON("index.php?geo&getregions&" + $(this).val(), function(data) {
				$.each(data.Items, function(index, item) {
					selectitems += "<option value='" + item.country_code + "|" + item.region_code + "'>" + item.name + "</option>";
				});
				$("#geo_regions").html(selectitems).prop("disabled", false).trigger("chosen:updated");
			});
		} else {
			$('#geo_regions').html("").prop("disabled", true).trigger("chosen:updated");
			$('#geo_cities').html("").prop("disabled", true).trigger("chosen:updated");
		}
	});

	$('#geo_regions').change(function(){

		if (($(this).val() != null) && ($(this).val().length == 1)) {
			$("#geo_cities_chosen").find('input').val('Looking up...');
			var selectitems = "";
			$.getJSON("index.php?geo&getcities&" + $(this).val(), function(data) {
				$.each(data.Items, function(index, item) {
					selectitems += "<option value='" + item.country_code + "|" + item.region_code + "|" + item.name_encoded + "'>" + item.name + "</option>";
				});
				$("#geo_cities").html(selectitems).prop("disabled", false).trigger("chosen:updated");
			});
		} else {
			$('#geo_cities').html("").prop("disabled", true).trigger("chosen:updated");
		}
	});


});

$(function (){
	setTimeout(function(){
		$("input:text:visible:first").focus();
	}, 0);
});