<?php


/** Generate Emails and Send Them
 * Class Email
 */
class Email {

	/**
	 * @param $sale \Models\Sale
	 * @param $saleRecord \Models\Salerecord
	 * @param $ad \Models\Ad
	 */
	public static function sendAdvertiserSpotPurchase($sale, $saleRecord, $ad){
		$f3 = \Base::instance();
		$f3->set('inc', 'email-advertiser-spot-purchase.html');
		$baseUrl = $f3->get('SCHEME').'://'.$f3->get('HOST').$f3->get('BASE');

		$ad->dry() ? $f3->set('ads_url', $baseUrl.'/index.php?ads&list') : $f3->set('ads_url', $baseUrl.'/index.php?ads&edit&'.$ad->_id);
		$f3->set('stats_url', $baseUrl.'/index.php?stats');

		$title = $f3->get('lang_your_spot_purchase').' | '.$sale->site_name;
		$f3->set('title', $title);
		$f3->set('sale_record', $saleRecord);
		$f3->set('sale', $sale);

		$f3->set('purchase_date', date('Y-m-d', $saleRecord->last_updated));

		$pricingTypes = Sales::pricingTypes($f3);
		$pricingType = $sale->pricing_type;
		if (($pricingType == 'cpm') || ($pricingType == 'cpc')){
			$f3->set('quantity', $saleRecord->quantity.' x '. $pricingTypes[$pricingType]['name']);
		} else {
			$f3->set('quantity', $pricingTypes[$pricingType]['name']);
		}

		$to = $saleRecord->buyer_email;

		$message = Template::instance()->render('email-layout.html','text/html');

		$bcc = '';
		$user = new \Models\User();
		$user->load(array('role=9 AND receive_mail=1'));
		if (!$user->dry()) $bcc = $user->mail;

		Utils::SendMail($message, $title, $to, $bcc);
	}

	/**
	 * @param $ad \Models\Ad
	 */
	public static function sendAdLimitReached($ad){
		$f3 = \Base::instance();

		$baseUrl = $f3->get('SCHEME').'://'.$f3->get('HOST').str_replace('api','admin',$f3->get('BASE'));

		$f3->set('limit_reached_date', date('Y-m-d H:i', $ad->limit_reached_date).' '.date_default_timezone_get());

		//Set UI/LOCALES param, since could be coming from API side
		if ($f3->get('UI') == './'){
			$config = new \Models\Config();
			$config->load(array('_id=?',1), null, 3600);
			$config->site_template != null ? $f3->set('UI','../admin/ui/'.$config->site_template.'/') : $f3->set('UI','../admin/ui/default/');
			$f3->set('LOCALES', '../admin/app/dict/');
		}

		$to = '';
		$bcc = '';
		if ($ad->sale_record != null){
			$f3->set('inc', 'email-advertiser-spot-limit-reached.html');

			$bcc = '';
			$user = new \Models\User();
			$user->load(array('role=9 AND receive_mail=1'));
			if (!$user->dry()) $bcc = $user->mail;

			$sale = $ad->sale;
			$saleRecord = $ad->sale_record;

			$title = $f3->get('lang_ad_limit_reached').' | '.$sale->site_name;
			$f3->set('title', $title);
			$f3->set('sale_record', $saleRecord);
			$f3->set('sale', $sale);
			$f3->set('stats_url', $baseUrl.'/index.php?stats');
			$f3->set('spots_url', $baseUrl.'/index.php?spots&'.$sale->site_key);
			$user = new \Models\User();
			$user->load(array('_id=? AND receive_mail=1',$ad->advertiser->_id));
			if (!$user->dry()) $to = $user->mail;

		} else {

			$f3->set('inc', 'email-admin-ad-limit-reached.html');

			$title = $f3->get('lang_spot_limit_reached').' | mySimpleAds';
			$f3->set('title', $title);
			$f3->set('ad', $ad);
			$f3->set('ad_url', $baseUrl.'/index.php?ads&edit&'.$ad->_id);

			$user = new \Models\User();
			$user->load(array('role=9 AND receive_mail=1'));
			if (!$user->dry()) $to = $user->mail;
		}

		if (empty($to)) return;
		$message = Template::instance()->render('email-layout.html','text/html');

		Utils::SendMail($message, $title, $to, $bcc);
	}


	public static function sendWeeklyStats(){
		$f3 = \Base::instance();

		$baseUrl = $f3->get('SCHEME').'://'.$f3->get('HOST').str_replace('api','admin',$f3->get('BASE'));

		//Set UI/LOCALES param, since could be coming from API side
		if ($f3->get('UI') == './'){
			$config = new \Models\Config();
			$config->load(array('_id=?',1), null, 3600);
			$config->site_template != null ? $f3->set('UI','../admin/ui/'.$config->site_template.'/') : $f3->set('UI','../admin/ui/default/');
			$f3->set('LOCALES', '../admin/app/dict/');
		}

		$to = '';
		$bcc = '';

		$user = new \Models\User();
		$user->load(array('role=9 AND receive_mail=1'));
		if (!$user->dry()) $to = $user->mail;

		if (empty($to)) return;

		$statsData = new Statsdata();
		$weeklyCTR = $statsData->DashboardWeeklyCTR();
		$weeklySales = $statsData->DashboardWeeklySales();

		$f3->set('inc', 'email-admin-stats.html');

		$title = $f3->get('lang_your_weekly_stats').' | mySimpleAds';
		$f3->set('title', $title);
		$f3->set('from_date', date('Y-m-d', strtotime('-7 days')));
		$f3->set('to_date', date('Y-m-d'));
		$f3->set('weekly_ctr', $weeklyCTR);
		$f3->set('weekly_sales', $weeklySales);
		$f3->set('stats_url', $baseUrl.'/index.php?stats');

		$message = Template::instance()->render('email-layout.html','text/html');

		Utils::SendMail($message, $title, $to, $bcc);
	}

}