<?php

namespace Models;

class Salerecord extends DB_Resource {

	protected
			$fieldConf = array(
			'date' => array(
					'type' => 'INT4'
			),
			'sale_id' => array(
					'belongs-to-one' => '\Models\Sale',
			),
			'transaction_reference' => array(
					'type' => 'VARCHAR128',
					'nullable' => false,
					'required'=>true,
			),
			'user_id' => array(
					'type' => 'INT2',
			),
			'buyer_email' => array(
					'type' => 'VARCHAR256',
			),
			'payment_status' => array(
					'type' => 'VARCHAR256',
					'nullable'=>false,
					'required'=>true,
			),
			'payment_amount' => array(
					'type' => 'DOUBLE',
					'nullable' => false,
					'required'=>true,
			),
			'payment_currency' => array(
					'type' => 'VARCHAR128',
					'nullable'=>false,
					'required'=>true,
			),
			'quantity' => array(
					'type' => 'INT2',
					'nullable'=>false,
					'required'=>true,
			),
			'error' => array(
					'type' => 'TEXT',
			),
			'last_updated' => array(
					'type' => 'INT4',
			),
	),
			$table = 'sales_records';

	public function save(){
		$this->last_updated = time();
		parent::save();
	}

}
