<?php
namespace Models;

/**
 * Class Config
 * @param $f3 \Base
 * @package Models
 */
class Config extends DB_Resource {

	protected
			$fieldConf = array(
			'purchase_account' => array(
					'type' => 'VARCHAR256',
			),
			'paypal_api_username' => array(
					'type' => 'VARCHAR256',
			),
			'paypal_api_password' => array(
					'type' => 'VARCHAR256',
			),
			'paypal_api_signature' => array(
					'type' => 'VARCHAR256',
			),
			'stripe_publishable_key' => array(
					'type' => 'VARCHAR256',
			),
			'stripe_secret_key' => array(
					'type' => 'VARCHAR256',
			),
			'coinbase_api_key' => array(
					'type' => 'VARCHAR256',
			),
			'coinbase_api_secret' => array(
					'type' => 'VARCHAR256',
			),
			'payment_methods' => array(
					'type' => 'VARCHAR256',
			),
			'sales_test' => array(
					'type' => 'BOOLEAN',
					'default' => 1,
			),
			'default_country' => array(
					'type' => 'VARCHAR128',
					'default' => 'US',
			),
			'mail_type' => array(
					'type' => 'INT1',
					'nullable' => false,
					'default' => 1,
			),
			'mail_smtp_host' => array(
					'type' => 'VARCHAR128',
			),
			'mail_smtp_auth' => array(
					'type' => 'BOOLEAN',
					'default' => 1,
			),
			'mail_smtp_username' => array(
					'type' => 'VARCHAR128',
			),
			'mail_smtp_password' => array(
					'type' => 'VARCHAR256',
			),
			'mail_smtp_port' => array(
					'type' => 'INT2',
					'default' => 465,
			),
			'mail_smtp_secure' => array(
					'type' => 'VARCHAR128',
					'default' => 'SSL',
			),
			'mail_from_email' => array(
					'type' => 'VARCHAR128',
			),
			'mail_from_name' => array(
					'type' => 'VARCHAR128',
			),
			'site_template' => array(
					'type' => 'VARCHAR128',
			),
			'site_theme' => array(
					'type' => 'VARCHAR128',
			),
			'site_logo_url' => array(
					'type' => 'VARCHAR256',
			),
			'site_scheduler' => array(
					'type' => 'BOOLEAN',
					'default' => 1,
			),
			'stats_ip_ignore' => array(
					'type' => 'VARCHAR256',
			),
			'last_notification' => array(
					'type' => 'INT4',
			),
			'last_notification_check' => array(
					'type' => 'INT4',
			),
			'last_updated' => array(
					'type' => 'INT4',
			),
	),
			$table = 'config';

	public function get_site_template($val){
		if (empty($val)) return 'default';
		return $val;
	}

	public function set_site_template($val){
		if ($val == 'default') return null;
		return $val;
	}

	public function get_site_theme($val){
		if (empty($val)) return 'gray';
		return $val;
	}

	public function set_site_theme($val){
		if ($val == 'gray') return null;
		return $val;
	}

	public function set_purchase_account($val){
		if (empty($val)) return ($val);
		return (\Utils::Encrypt($val));
	}

	public function get_purchase_account($val){
		if (empty($val)) return ($val);
		return (\Utils::Decrypt($val));
	}

	public function set_mail_smtp_password($val){
		if (empty($val)) return ($val);
		return (\Utils::Encrypt($val));
	}

	public function get_mail_smtp_password($val){
		if (empty($val)) return ($val);
		return (\Utils::Decrypt($val));
	}

	public function set_paypal_api_username($val){
		if (empty($val)) return ($val);
		return (\Utils::Encrypt($val));
	}

	public function get_paypal_api_username($val){
		if (empty($val)) return ($val);
		return (\Utils::Decrypt($val));
	}

	public function set_paypal_api_password($val){
		if (empty($val)) return ($val);
		return (\Utils::Encrypt($val));
	}

	public function get_paypal_api_password($val){
		if (empty($val)) return ($val);
		return (\Utils::Decrypt($val));
	}

	public function set_paypal_api_signature($val){
		if (empty($val)) return ($val);
		return (\Utils::Encrypt($val));
	}

	public function get_paypal_api_signature($val){
		if (empty($val)) return ($val);
		return (\Utils::Decrypt($val));
	}

	public function set_stripe_publishable_key($val){
		if (empty($val)) return ($val);
		return (\Utils::Encrypt($val));
	}

	public function get_stripe_publishable_key($val){
		if (empty($val)) return ($val);
		return (\Utils::Decrypt($val));
	}

	public function set_stripe_secret_key($val){
	if (empty($val)) return ($val);
	return (\Utils::Encrypt($val));
}

	public function get_stripe_secret_key($val){
		if (empty($val)) return ($val);
		return (\Utils::Decrypt($val));
	}

	public function set_coinbase_api_key($val){
		if (empty($val)) return ($val);
		return (\Utils::Encrypt($val));
	}

	public function get_coinbase_api_key($val){
		if (empty($val)) return ($val);
		return (\Utils::Decrypt($val));
	}

	public function set_coinbase_api_secret($val){
		if (empty($val)) return ($val);
		return (\Utils::Encrypt($val));
	}

	public function get_coinbase_api_secret($val){
		if (empty($val)) return ($val);
		return (\Utils::Decrypt($val));
	}
}
