<?php

class Stats extends Controller{

	/**
	 * @param $f3 \Base
	 */
	public function getIndex($f3){
		$f3->set('active','stats');
		$f3->set('inc','stats.html');
		$f3->set('inc_bottom', 'stats-bottom.html');
		$f3->set('title',$f3->get('lang_stats'));


		$statsData = new Statsdata();
		$f3->set('selects', $statsData->GetSelectList());

		echo Template::instance()->render('layout.html');
	}

	/**
	 * @param $f3 \Base
	 */
	public function postIndex($f3){
		$select = $f3->get('POST.selects');
		if (empty($select)) return;

		$reportRange = $f3->get('POST.reportrange');
		if (empty($reportRange)) return;

		// Get dates
		$reportRanges = explode('-', $reportRange);
		if (count($reportRanges) < 2) return;
		$startDateTime = strtotime(trim($reportRanges[0]));
		$endDateTime = strtotime(trim($reportRanges[1]));

		if ((empty($startDateTime)) || (empty($endDateTime))) return;
		if ($startDateTime > $endDateTime) return;


		// Get type|id
		$selects = explode('|', $select);
		if (count($selects) < 2) return;
		$type = $selects[0];
		$id = $selects[1];
		if (!is_numeric($id)) return;

		$statsData = new Statsdata();
		$stats = $statsData->GetStats($startDateTime, $endDateTime, $type, $id);

		$f3->set('start_date', date('F d, Y', $startDateTime));
		$f3->set('end_date', date('F d, Y', $endDateTime));
		$f3->set('stats_type', $type);
		$f3->set('stats', $stats);

		echo Template::instance()->render('stats-graphs.html');
	}


}