<?php

class Dashboard extends Controller{

	//! HTTP route pre-processor
	/**
	 * @param $f3 \Base
	 */
	function beforeroute($f3) {
		parent::beforeroute($f3);

		// Only admins/super admins can use this class
		if ($f3->get('USER')->role < 8){
			$f3->reroute('/index.php?ads&list');
		}
	}

	/**
	 * @param $f3 \Base
	 */
	public function getIndex($f3){
		$f3->set('active','dashboard');
		$f3->set('inc','dashboard.html');
		$f3->set('inc_bottom', 'dashboard-bottom.html');
		$f3->set('title',$f3->get('lang_dashboard'));

		$statsdata = new Statsdata();
		$f3->set('top_ads', $statsdata->DashboardTopAds());
		$f3->set('top_groups', $statsdata->DashboardTopGroups());
		$f3->set('top_sales', $statsdata->DashboardTopSales());
		$f3->set('spark_weekly_impressions', $statsdata->DashboardWeeklyImpressions());
		$f3->set('spark_weekly_ctr', $statsdata->DashboardWeeklyCTR());
		$f3->set('spark_weekly_sales', $statsdata->DashboardWeeklySales());

		echo Template::instance()->render('layout.html');
	}

	/**
	 * @param $f3 \Base
	 */
	public function getChartData($f3){
		$graphing = new Statsdata();
		if ($f3->get('PARAMS.type') == 'ad'){
			echo $graphing->DashboardGraphAdGroupJson();
		} elseif ($f3->get('PARAMS.type') == 'sale'){
			echo $graphing->DashboardGraphSalesLandingPageJson();
		}
	}

}
