<?php

//! Base controller
class Controller {

	//! HTTP route pre-processor
	/**
	 * @param $f3 \Base
	 */
	function beforeroute($f3) {

		// Security headers
		//header("Content-Security-Policy: script-src 'self' 'unsafe-inline' https://apis.google.com http://ajax.googleapis.com https://ajax.googleapis.com https://www.google.com/jsapi", true);
		//header("X-Frame-Options: DENY", true);
		//header("X-Content-Type-Options: nosniff", true);

		// Check if logged in
		if (!Account::isLoggedIn()){
			$f3->reroute('/index.php?login&ret='.urlencode(str_replace($f3->get('BASE'), '', $f3->get('URI'))));
		}

		// Set template and theme (if not default)
		$config = new \Models\Config();
		$config->load(array('_id=?',1), null, 3600);
		if ($config->site_template != 'default') $f3->set('UI','ui/'.$config->site_template.'/'.';'.$f3->get('UI'));
		if ($config->site_theme != 'gray') $f3->set('THEME',$config->site_theme);
		if ($config->site_logo_url != '') $f3->set('LOGO_URL',$config->site_logo_url);

		// Only admins/super admins can do this function
		if ($f3->get('USER')->role >= 8){
			if (($config->last_notification_check == null) || ($config->last_notification_check < mktime(0,0,0))){
				$last_notification = Utils::getNotifications($config->last_notification ? $config->last_notification : 1, $config->purchase_account);
				$config->last_notification_check = time(); // Check daily
				if (!empty($last_notification)) $config->last_notification = $last_notification;
				$config->save();
				$config->load(array('_id=?',1), null, 1); // Update cache
			}
		}

	}

	//! HTTP route post-processor
	function afterroute() {
	}

	//! Instantiate class
	function __construct() {
	}

}
